**************************************************************************************************
*******************"ADOPTION OF GPT" PAPER - EVENT STUDIES****************************************
*************************DATE: OCT 2023 **********************************************************
************************ AUTHOR: KIM NGUYEN AND JONATHAN HAMBUR **********************************
**************************************************************************************************

//LOAD DATA
use "Final_data.dta", clear
egen gics_y = group(gics_sector fy)


xtset id fy

** Set up treatment variable

g gentech_treat = 0 if fy <gentech_iy & gentech_iy!=.
replace gentech_treat = 0 if (gentech_iy==. & dprinting!=.)
replace gentech_treat = 1 if fy==gentech_iy | fy==gentech_iy-1
replace gentech_treat = 2 if fy==gentech_iy+1
replace gentech_treat = 3 if fy==gentech_iy+2
replace gentech_treat = 4 if fy>=gentech_iy+3 & gentech_iy!=.

** run staggered DD

xtreg roa i.gentech_treat##i.gentech_pcbi  i.gentech_pcbi#(c.logassets i.gics_y)  if fy>=2015 &  sector!="IT" & lateadopters!=2 , fe cluster(id)
xtreg roa i.gentech_treat##i.female_pcbi  i.female_pcbi#(c.logassets i.gics_y)  if fy>=2015 & sector!="IT" & lateadopters!=2, fe cluster(id)
xtreg roa i.gentech_treat##i.lateadopters c.logassets##i.lateadopters i.gics_y if fy>=2011 & sector!="IT", fe cluster(id)

esttab  using "staggeredDDD.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps
